// types/packs.ts
export interface Card {
  id: number;
  name: string;
  image: string;
}

export interface ApiPack {
  id: number;
  name: string;
  price: number;
  image: string; // e.g. "/packs/phantasmal-flames.png"
}
export interface ApiCard {
  id: number;
  name: string;
  price: number;
  image: string; // relative path from API
}
export interface PackCard {
  id: number;
  name: string;
  image: string; // full URL
}

export interface PackData {
  id: number;
  name: string;
  price: number;
  image: string; // full URL for pack image
  cards: PackCard[];
}

export interface PackApiResponse {
  resp: string;
  packs: {
    id: number;
    name: string;
    price: number;
    image: string;
  }[];
}

export interface CardsApiResponse {
  resp: string;
  cards: Card[];
}

export interface PackData {
  id: number;
  name: string;
  price: number;
  /** Normalized field for the image */
 packImage : string;
}

export interface ApiPacksResponse {
  resp: "success" | "error";
  packs: ApiPack[];
}

export interface ApiCardsResponse {
  resp: "success" | "error";
  cards: Card[];
}

export interface Card {
  id: number;
  name: string;
  image: string;
  rarity?: string;
  [key: string]: any; 
}

export interface PackWithCards extends ApiPack {
  cards?: Card[];
}
