// lib/auth.ts
import { cookies } from "next/headers";
import { User } from "../store/authSlice";

export async function getServerUser(): Promise<{} | null> {
  const cookieStore = await cookies();
  const token = cookieStore.get("auth_token")?.value;

  if (!token) return null;

  
  return {
    id: "1",
    userId: "1",            // ✅ add this
    token: "",              // ✅ add this (or real token)
    name: "Demo User",
    email: "demo@example.com",
  };
}
