import { BASE_URL, forceLogout, parseJsonOrLogout } from "@/constants";

export const getFreeSpin = async () => {
  const res = await fetch(`${BASE_URL}/api/get-spin`, {
    // method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
  });
  return parseJsonOrLogout(res);
};

export const getSpinSub = async (
  token: string,
  userId: string,
  index: number,
) => {
  const res = await fetch(
    `${BASE_URL}/api/get-spin-sb?user_id=${encodeURIComponent(
      userId,
    )}&index=${index}`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      },
    },
  );
  return parseJsonOrLogout(res);
};

export async function getSpinHistory(user_id: string, token: string) {
  try {
    const res = await fetch(`${BASE_URL}/api/spin-history`, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      },
      body: JSON.stringify({ user_id }),
    });

    return parseJsonOrLogout(res);
  } catch (e) {
    throw e;
  }
}

export const fetchSpinPrices = async () => {
  const res = await fetch(`${BASE_URL}/api/spin-prices`, {
    method: "POST",
  });

  return parseJsonOrLogout(res);
};
