import { BASE_URL, parseJsonOrLogout } from "@/constants";

export const chatAllowed = async (user_id: string, token: string) => {
  const res = await fetch(`${BASE_URL}/api/chat-allowed`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token}`,
    },
    body: JSON.stringify({ user_id }),
  });
  return parseJsonOrLogout(res);
};
