import { BASE_URL, forceLogout, parseJsonOrLogout } from "@/constants";

export type BlogDetail = {
  id: number;
  date: string;
  title: string;
  image: string;
  content: string;
};

const SHARED_CONTENT = `What’s Going On?
Leaks just hit the Pokémon TCG world—and they’re spicy. According to multiple sources, The Pokémon Company is working on a Black & White era revival set, and let’s just say, Gen 5 fans are about to have a field day.

The news came from a series of leaks that surfaced online, hinting at an upcoming set featuring reprinted EX cards, iconic Legendaries, and major throwbacks from the Unova region. Yes—you read that right. We’re talking Reshiram, Zekrom, Victini, and a full wave of nostalgia.

What’s In the Leaks?
From what’s been uncovered so far, this new set (name still TBD) is looking stacked:

• Reprints of classic Black & White cards
• Iconic Full Arts and EXs like Mewtwo EX and Reshiram EX
• New artworks for N, Colress, and other B&W-era Trainers
• Possible reworkings of original B&W mechanics
• And no joke—some images show the cards with modern foil treatments, which look straight-up clean.

This isn’t just a copy-paste set either. It seems like the reprints will come with minor tweaks to balance them for current Standard play. Think of it like Crown Zenith meets Celebrations but all about Gen 5.

Why Does This Matter?
Let’s be real—Gen 5 is one of those eras that flew under the radar at launch, but in recent years? It’s been blowing up.

Collectors are paying top dollar for sealed B&W packs. Full art Trainers from that era are climbing in value, and any B&W-era Pokémon getting love in Scarlet & Violet is seeing a spike. This leak basically confirms what we all suspected: The Pokémon Company sees the hype too.

Plus, EX cards coming back? Huge win for longtime collectors who missed those bold, textured designs.

When Is This Dropping?
Nothing official yet—but based on typical leak-to-release timelines, we might see a reveal within the next 1-2 sets. Some are speculating a late summer release, possibly filling the Celebrations-style slot for this year.

Where Can I Open Them Online?
You already know where this is going...

Once the set is officially announced, we’ll be ready at Open That Pack with live online breaks, fair pack odds, and the option to sell or ship your pulls instantly.

No scalpers. No overpriced B&W reprint boxes. Just straight-up fun and real cards.

Final Thoughts
Pokémon TCG throwing it back to the Black & White era? Yes please. Whether you're a Gen 5 mega-fan or just down for clean EX reprints, this set might be one of the most hype-filled drops in years.

Keep your eyes on the news, and keep your hands ready to rip some packs.`;

export const BLOGS: BlogDetail[] = [
  {
    id: 1,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
  {
    id: 2,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
  {
    id: 3,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
  {
    id: 4,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
  {
    id: 5,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
  {
    id: 6,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
  {
    id: 7,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
  {
    id: 8,
    date: "October 14, 2024",
    title: "Pokémon TCG: Black & White Revival Set Leaks",
    image: "/images/blogs/img.svg", // or your real image path
    content: SHARED_CONTENT,
  },
];

export async function fetchBlogs(page: any) {
  const res = await fetch(
    `https://backend.openthatcard.com/api/get-blogs?page=${page}`,
    {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
      },
      cache: "no-store",
    },
  );

  return parseJsonOrLogout(res);
}

export async function fetchBlogDetail(slug: string) {
  const res = await fetch(
    `https://backend.openthatcard.com/api/get-blog-detail??slug=${slug}`,
    {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
      },
      cache: "no-store",
    },
  );
  
  return parseJsonOrLogout(res);
}
