"use client";

import { useState } from "react";
type FaqItem = {
  question: string;
  answer: string;
};

type FaqCategory = {
  id: string;
  title: string;
  items: FaqItem[];
};

const faqData: FaqCategory[] = [
  {
    id: "general",
    title: "GENERAL QUESTIONS",
    items: [
      {
        question: "What is Open That Pack?",
        answer:
          "Open That Pack is a virtual pack opening platform where you can open trading card packs online and receive the physical cards afterward.",
      },
      {
        question: "How Does Virtual Pack Opening Work?",
        answer:
          "You purchase a pack, watch it be opened on stream or via video, and then decide if you want the cards shipped or traded back.",
      },
      {
        question: "Why Are Your Packs Cheaper?",
        answer:
          "We work with distributors and buy in bulk, which lets us offer packs at a lower cost while still remaining fully licensed.",
      },
      {
        question: "How Do I Know This Is Legit?",
        answer:
          "All packs are factory sealed and opened on camera. Orders and tracking are handled through our secure system.",
      },
      {
        question: "What Currency Is The Site Denominated In?",
        answer:
          "All prices are shown and charged in USD unless otherwise specified at checkout.",
      },
    ],
  },
  {
    id: "shipping",
    title: "SHIPPING & TRADE-BACK",
    items: [
      {
        question: "How Do I Get My Cards?",
        answer:
          "Once your order is processed, you can request shipment. We safely package and ship your cards to the address on file.",
      },
      {
        question: "What If I Don’t Like My Cards?",
        answer:
          "You can use our trade-back system (when available) to exchange eligible cards for store credit.",
      },
      {
        question: "Can I Buy Single Cards?",
        answer:
          "Yes, select singles are available in our marketplace section in addition to sealed product.",
      },
      {
        question: "How Fast Do You Ship Orders?",
        answer:
          "Most in-stock orders leave our warehouse within 1–3 business days after shipment is requested.",
      },
      {
        question: "How Fast Is Shipping?",
        answer:
          "Delivery time depends on the carrier and your location, but typically ranges from 3–10 business days.",
      },
      {
        question:
          "Can I place multiple orders even if my initial order hasn’t been delivered yet?",
        answer:
          "Absolutely. Each order is processed separately, and you can choose when to combine and ship them.",
      },
      {
        question: "Which Countries Do You Ship To?",
        answer:
          "We currently ship to most major regions. Exact availability and rates appear at checkout.",
      },
      {
        question: "Why is there a bulk surcharge?",
        answer:
          "Large or heavy shipments may incur a small surcharge to cover increased packaging and carrier fees.",
      },
    ],
  },
  {
    id: "fairness",
    title: "FAIRNESS & SECURITY",
    items: [
      {
        question: "Is Pack Opening Fair?",
        answer:
          "Yes. Packs are opened exactly as they come from the manufacturer—no mapping, weighing, or resealing.",
      },
      {
        question: "What Happens If You Run Out of Inventory?",
        answer:
          "If we oversell a product, we’ll contact you with alternatives or offer a full refund for that item.",
      },
      {
        question: "How Can I Contact Support?",
        answer:
          "You can reach our support team via the contact form on the site or by emailing support@example.com.",
      },
    ],
  },
];
const Inner = () => {
  // store `${categoryId}-${index}` for the currently open item
  const [openId, setOpenId] = useState<string | null>(null);

  const handleToggle = (id: string) => {
    setOpenId((prev) => (prev === id ? null : id));
  };
  return (
    <div className="min-h-screen bg-[var(--color-black)] text-white">
      {/* Header */}
      {/* sticky top-0 */}
      <div className=" z-10">
        <div className="container mx-auto py-4">
          <div className="flex items-center gap-4">
            <button
              // onClick={() => setIsOpenCardModal(true)}
              className="cursor-pointer text-xs md:text-sm p-2 px-4 font-extrabold text-white bg-[var(--color-gray)] hover:text-white italic font-sofia transition"
            >
              &lt; BACK
            </button>
            <h1 className="text-sm md:text-base font-extrabold italic tracking-tighter">
              FREQUENTLY ASKED QUESTIONS
            </h1>
          </div>
          <div className="mx-auto max-w-4xl lg:px-8">
            {faqData.map((category) => (
              <div key={category.id} className="mb-10 sm:mb-12 lg:mb-16">
                {/* Category title */}
                <h2 className="mb-4 text-sm md:text-base font-extrabold italic tracking-tighter text-center mt-4 sm:mb-6">
                  {category.title}
                </h2>

                <div className="space-y-2 rounded-md ">
                  {category.items.map((item, idx) => {
                    const id = `${category.id}-${idx}`;
                    const isOpen = openId === id;

                    return (
                      <div key={id} className="bg-[#161E2A]">
                        <button
                          type="button"
                          onClick={() => handleToggle(id)}
                          className="flex w-full items-center justify-between px-4 py-3 text-left text-[13px] font-medium  hover:bg-slate-800 sm:px-5 sm:py-3.5 sm:text-sm"
                          aria-expanded={isOpen}
                        >
                          <span className="pr-4">{item.question}</span>
                          <span className="ml-auto flex h-6 w-6 shrink-0 items-center justify-center border-slate-500 text-xs font-bold ">
                            {isOpen ? "−" : "+"}
                          </span>
                        </button>

                        {/* Answer */}
                        <div
                          className="overflow-hidden transition-all duration-300 ease-in-out"
                          style={{
                            maxHeight: isOpen ? "500px" : "0px",
                            opacity: isOpen ? 1 : 0,
                          }}
                        >
                          <div className="px-4 mt-5 pb-4 text-[13px] sm:px-5 sm:text-sm">
                            {item.answer}
                          </div>
                        </div>
                      </div>
                    );
                  })}
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default Inner;
