"use client";

import Image from "next/image";
import { useState } from "react";

export type Pack = {
  id: number;
  gems: number;
  price: number;
  wincoinsFree: number;
  img: string; // your diamond image path
  sparkle?: boolean;
};

export const packs: Pack[] = [
  {
    id: 1,
    gems: 200,
    price: 20,
    wincoinsFree: 20,
    img: "/images/wallet/diamond.svg",
  },
  {
    id: 2,
    gems: 500,
    price: 50,
    wincoinsFree: 50,
    img: "/images/wallet/diamond.svg",
    sparkle: true,
  },
  {
    id: 3,
    gems: 1000,
    price: 100,
    wincoinsFree: 100,
    img: "/images/wallet/diamond.svg",
    sparkle: true,
  },
  {
    id: 4,
    gems: 1500,
    price: 150,
    wincoinsFree: 1500,
    img: "/images/wallet/diamond.svg",
    sparkle: true,
  },
  {
    id: 5,
    gems: 2500,
    price: 300,
    wincoinsFree: 2500,
    img: "/images/wallet/diamond.svg",
    sparkle: true,
  },
  {
    id: 6,
    gems: 5000,
    price: 500,
    wincoinsFree: 5000,
    img: "/images/wallet/diamond.svg",
    sparkle: true,
  },
];

export default function GemsGrid({
  setBundles,
  onSelect,
  setDepositAmount,
}: any) {
  return (
    <div className="grid gap-3 sm:grid-cols-2 lg:grid-cols-3">
      {packs.map((p) => (
        <div
          key={p.id}
          onClick={() => {
            onSelect?.(p); // ✅ selected pack set
            setBundles(false); // existing
            setDepositAmount(p.price); // ✅ deposit amount set
          }}
          className="border border-[#29313D] cursor-pointer"
        >
          {/* Top bar */}
          <div className="flex items-center font-onest bg-[#29313D] gap-3 p-3 py-2">
            <img src="/images/wallet/coin.svg" className="w-5" alt="" />
            <div className="text-xs">
              {p.wincoinsFree.toFixed(2)} Free{" "}
              <span className="font-bold  text-white">WINCOINS</span>
            </div>
          </div>

          {/* Inner card */}
          <div className="">
            <div className="relative border border-white/10 bg-[#121924] pb-3">
              {/* Diamond */}
              <div className="relative mx-auto -mt-3 w-fit">
                <Image
                  src={p.img}
                  alt="Diamond"
                  width={160}
                  height={20}
                  className="relative z-10 "
                />
              </div>

              {/* Gems label */}
              <div className="text-center -mt-6 font-onest text-xs md:text-base font-semibold">
                {p.gems} Gems
              </div>

              {/* Price button */}
              <div className="mt-3 font-onest flex justify-center">
                <button className=" bg-(--color-blue) hover:bg-(--color-hoverBlue) px-5 py-1 font-normal text-xs md:text-base shadow hover:brightness-110">
                  ${p.price}
                </button>
              </div>
            </div>
          </div>
        </div>
      ))}
    </div>
  );
}
