// "use client";

// import React, { useState } from "react";
// import { InternalButton } from "../ui/Button";

// type OptionGroupProps = {
//   options: string[];
//   onChange?: (value: string) => void;
//   defaultValue?: string | null;
// };

// export const OptionGroup: React.FC<OptionGroupProps> = ({
//   options,
//   onChange,
//   defaultValue = null,
// }) => {
//   const [active, setActive] = useState<string | null>(defaultValue);

//   return (
//     <div className="flex flex-wrap items-center gap-4">
//       {options.map((opt) => {
//         const isActive = active === opt;

//         return (
//           <InternalButton
//             key={opt}
//             variant="outline"
//             onClick={() => {
//               setActive(opt);
//               onChange?.(opt); // 🔥 notify parent
//             }}
//             className={`
//               px-10 transition-all
//               ${
//                 isActive
//                   ? "bg-white !text-[var(--color-blue)] border-[var(--color-blue)] pointer-events-none"
//                   : "hover:bg-white cursor-pointer hover:text-[var(--color-blue)]"
//               }
//             `}
//           >
//             {opt}
//           </InternalButton>
//         );
//       })}
//     </div>
//   );
// };

"use client";

import React from "react";
import { InternalButton } from "../ui/Button";

type OptionGroupProps = {
  options: string[];
  value: string | null;                 // ✅ controlled value
  onChange?: (value: string) => void;
};

export const OptionGroup: React.FC<OptionGroupProps> = ({
  options,
  value,
  onChange,
}) => {
  return (
    <div className="flex flex-wrap font-onest items-center gap-4">
      {options.map((opt) => {
        const isActive = value === opt;

        return (
          <InternalButton
            key={opt}
            variant="outline"
            type="button"
            onClick={() => onChange?.(opt)}
            className={`
              px-10 transition-all
              ${
                isActive
                  ? "bg-white !text-[var(--color-blue)] border-[var(--color-blue)] pointer-events-none"
                  : "hover:bg-white cursor-pointer hover:text-[var(--color-blue)]"
              }
            `}
          >
            {opt}
          </InternalButton>
        );
      })}
    </div>
  );
};
