// types.tsx ya Buttons.tsx

import React from "react";
import clsx from "clsx";

type ButtonProps = React.ButtonHTMLAttributes<HTMLButtonElement> & {
  variant?: "solid" | "outline";
  className?: string;
};

export const PrimaryButton: React.FC<ButtonProps> = ({
  variant = "solid",
  className,
  children,
  ...props
}) => {
  const base =
    "inline-flex cursor-pointer items-center justify-center px-2 md:px-4 2xl:px-6 md:py-1 2xl:py-3 text-xs font-medium rounded-full transition-colors";

  const styles = {
    solid: " bg-[var(--color-blue)] text-white hover:bg-[#3c49d0]",
    outline:
      "border font-onest uppercase border-[var(--color-blue)] text-[var(--color-blue)] hover:bg-[var(--color-hoverBlue)] hover:text-white",
  };

  return (
    <button className={clsx(base, styles[variant], className)} {...props}>
      {children}
    </button>
  );
};

export const InternalButton: React.FC<ButtonProps> = ({
  variant = "solid",
  className,
  children,
  ...props
}) => {
  const base =
    "inline-flex cursor-pointer items-center justify-center px-2 md:px-6 py-2 2xl:py-3 text-xs md:!text-base  transition-colors";

  const styles = {
    solid: "bg-[var(--color-blue)] hover:bg-[var(--color-hoverBlue)] font-onest uppercase text-white",
    outline: "border border-white text-white hover:bg-[var(--color-gray)] ",
  };

  return (
    <button className={clsx(base, styles[variant], className)} {...props}>
      {children}
    </button>
  );
};


export const BorderButton: React.FC<ButtonProps> = ({
  variant = "solid",
  className,
  children,
  ...props
}) => {
  const base =
    "inline-flex items-center cursor-pointer justify-center px-2 md:px-6 md:py-1 2xl:py-3 text-xs md:!text-base !font-bold py-1 md:py-2 2xl:py-3 text-sm transition-colors font-onest";

  const styles = {
    solid:
      "hover:bg-[var(--color-gray)] text-[var(--color-blue)] bg-white font-onest",
    outline:
      "border border-white text-white hover:bg-white hover:text-black",
  };

  return (
    <button
      {...props}
      disabled={props.disabled}
      className={clsx(
        base,
        styles[variant],
        props.disabled && "opacity-50 cursor-not-allowed",
        className
      )}
    >
      {children}
    </button>
  );
};



