import React from "react";
import Toggle from "../ui/toggle";
type ToggleProps = {
  checked?: boolean;
  setBoltMode?: (val: boolean) => void;
  className?: string;
};
const OgBox = ({ checked, setBoltMode, className = "" }: ToggleProps) => {
  return (
    <div className="container mx-auto">
      <div className="flex items-center flex-col md:flex-row gap-5 my-5 md:my-6 2xl:my-10 bg justify-between px-5 md:px-8 py-4 md:py-6 ">
        <div className="flex gap-5">
          <button className="flex items-center gap-2 text-white italic hover:scale-105 duration-300 transition-all font-extrabold font-sofia">
            <span>&lt; BACK</span>
          </button>

          <div className="flex items-center gap-4">
            <div className="relative w-20 md:w-full xp-glow">
              <img
                src="/images/hero/OGBOX.png"
                alt="Box"
                className=" object-contain"
              />
            </div>
            <div>
              <h1 className="text-lg md:text-2xl w-full md:min-w-40 italic font-sofia font-extrabold text-white">
                THE BIG OG BOX
              </h1>
              <span className="text-[var(--color-pink)] text-xs font-sofia italic md:text-xl font-bold">
                $200
              </span>
            </div>
          </div>
        </div>

        <div className="flex items-center gap-2">
          <img src="/images/hero/star.png" alt="" />
          <span className="italic font-sofia font-extrabold text-xs text-[15px] text-[var(--color-slate)]">
            BOLTMODE
          </span>
          <Toggle checked={checked} onChange={(next) => setBoltMode?.(next)} />
        </div>
      </div>
    </div>
  );
};

export default OgBox;
