import Image from "next/image";

interface TabData {
  id: string;
  name: string;
  active: boolean;
  image: string;
}

const tabs: TabData[] = [
  {
    id: "magic",
    name: "MAGIC",
    image: "/images/inventory/magic.svg",
    active: false,
  },
  {
    id: "pokemon",
    name: "POKÉMON",
    image: "/images/inventory/pokemon.svg",
    active: true,
  },
  {
    id: "lorcana",
    name: "LORCANA",
    image: "/images/inventory/lorcana.svg",
    active: false,
  },
  {
    id: "riftbound",
    name: "RIFTBOUND",
    image: "/images/inventory/riftbound.png",
    active: false,
  },
];
export const Header: React.FC<{
  activeTab: string;
  onTabChange: (tabId: string) => void;
}> = ({ activeTab, onTabChange }) => (
  <header className=" pt-5 z-50 ">
    <div className="container mx-auto ">
      <nav className="flex items-center justify-between flex-col md:flex-row gap-4 mb-6 xl:mb-0 h-16">
        {/* <div className="flex items-center gap-4">
          <button className="text-xs md:text-sm 2xl:text-base p-2 px-4 font-extrabold text-white bg-[var(--color-gray)] hover:text-white italic font-sofia transition">
            &lt; BACK
          </button>
          <h1 className="text-sm md:text-3xl font-extrabold text-white italic font-sofia tracking-tighter">
            PACKS
          </h1>
        </div> */}
        <div className="flex items-stretch">
          {tabs.map((tab) => (
            <button
              key={tab.id}
              onClick={() => onTabChange(tab.id)}
              className={`
        flex items-center justify-center
        px-4 xl:px-16 
        h-14 xl:h-20              
        font-extrabold transition-all text-xs 2xl:text-lg 
        bg-[var(--color-naviBlue)] border-b-3 font-sofia border-transparent md:text-base
        ${
          activeTab === tab.id
            ? "text-white !border-[var(--color-blue)] pointer-events-none"
            : "text-[var(--color-slate)] cursor-pointer hover:bg-gray-700/50 opacity-90"
        }
      `}
            >
              <Image
                width={117}
                height={37}
                src={tab.image}
                alt={tab.name}
                className="h-6 md:h-8 " /* 👈 height fix, width auto so ratio same */
              />
            </button>
          ))}
        </div>
      </nav>
    </div>
  </header>
);
