import { useEffect, useState } from "react";
import { getSocket } from "../utils/socket";

export default function Game({ playerName, startingBalance }) {
  const [players, setPlayers] = useState([]);
  const [myCards, setMyCards] = useState([]);

  useEffect(() => {
    const socket = getSocket();

    // Initialize the server connection
    socket.emit("joinGame", {
      name: playerName,
      balance: startingBalance,
      playCards: [],
    });

    // Listen for updates
    socket.on("updatePlayers", (updatedPlayers) => {
      setPlayers(updatedPlayers);
      const me = updatedPlayers.find((p) => p.name === playerName);
      if (me) setMyCards(me.playCards);
    });

    return () => {
      socket.off("updatePlayers");
    };
  }, [playerName, startingBalance]);

  const playCard = (card) => {
    const socket = getSocket();
    socket.emit("playCard", { playerId: socket.id, card });
  };
  return <></>;
}
