import Image from "next/image";
import { useState } from "react";
import ProfileDetailDrawer from "./ProfileDetailDrawer";
import { User } from "@/constants/types";
type CardDrop = {
  id: number;
  date: string;
  title: string;
  price: string;
  image: string; // image path
};

const MOCK_DROPS: CardDrop[] = [
  {
    id: 1,
    date: "7TH JULY 2025",
    title: "RAGING BOLT EX",
    price: "$121.90",
    image: "/images/profile/img2.svg",
  },
  {
    id: 2,
    date: "14TH JULY 2025",
    title: "FROSTED BLAZE",
    price: "$135.50",
    image: "/images/profile/img2.svg",
  },
  {
    id: 3,
    date: "21ST JULY 2025",
    title: "SHADOW STRIKE",
    price: "$149.75",
    image: "/images/profile/img2.svg",
  },
  {
    id: 4,
    date: "7TH JULY 2025",
    title: "RAGING BOLT EX",
    price: "$121.90",
    image: "/images/profile/img2.svg",
  },
  {
    id: 5,
    date: "14TH JULY 2025",
    title: "FROSTED BLAZE",
    price: "$135.50",
    image: "/images/profile/img2.svg",
  },
  {
    id: 6,
    date: "21ST JULY 2025",
    title: "SHADOW STRIKE",
    price: "$149.75",
    image: "/images/profile/img2.svg",
  },
  {
    id: 7,
    date: "21ST JULY 2025",
    title: "SHADOW STRIKE",
    price: "$149.75",
    image: "/images/profile/img2.svg",
  },
  // ...repeat / add more
];
type props = {
  user: User | null;
};
const TradeListings = ({ user }: props) => {
  const [detailCard, setDetailCard] = useState<CardDrop | null>(null);
  return (
    <div>
      <h1 className="bg-[var(--color-gray)] font-onest font-bold text-sm md:text-xl 2xl:text-2xl p-4">
        Trade Listings{" "}
      </h1>
      <div className="py-4  border border-[var(--color-gray)]">
        <section className="w-full">
          {/* horizontal scroll on small screens, grid on large */}
          <div className="nice-scrollbar -mx-4 flex gap-4 overflow-x-auto px-4 lg:mx-0 grid grid-cols-2 md:grid-cols-4 2xl:grid-cols-6 lg:overflow-visible">
            {MOCK_DROPS.map((card) => (
              <article
                onClick={(e) => {
                  e.stopPropagation();
                  setDetailCard(card);
                }}
                key={card.id}
                className="flex cursor-pointer flex-col bg-[var(--color-naviBlue)] text-white shadow-lg shadow-black/40"
              >
                {/* Top: date */}
                <div className="px-3 pt-3 text-[10px] font-sofia  font-semibold tracking-[0.18em] text-white uppercase ">
                  {card.date}
                </div>

                {/* Image */}
                <div className="relative mx-3 mt-2 h-40 overflow-hidden ">
                  <Image
                    src={card.image}
                    alt={card.title}
                    fill
                    className="object-contain"
                  />
                </div>

                {/* Bottom: title + price */}
                <div className=" bg-blur relative z-10 px-3 -mt-7 pb-4 pt-3 text-center">
                  <p className="text-xs md:text-sm font-sofia font-normal tracking-[0.16em] uppercase">
                    {card.title}
                  </p>
                  <p className="text-xs md:text-base font-extrabold font-sofia">
                    {card.price}
                  </p>
                </div>
              </article>
            ))}
          </div>
        </section>
      </div>
      <ProfileDetailDrawer
        card={detailCard}
        onClose={() => setDetailCard(null)}
      />
    </div>
  );
};

export default TradeListings;
