import { User } from "@/constants/types";
import { StatCard } from "./StateCard";
import Link from "next/link";
type OverviewContentProps = {
  user: User | null;
  homeData: any;
  loadingProfileData: boolean;
  errorProfileLoad: string | null;
};
export const OverviewContent: React.FC<OverviewContentProps> = ({
  user,
  homeData,
  loadingProfileData,
  errorProfileLoad,
}) => {
  return (
    <div className="space-y-8 p-4  border border-[var(--color-gray)] md:p-6 2xl:p-8">
      {/* Inventory stats header */}
      <div className="flex flex-wrap items-center  gap-2">
        <h2 className="text-sm flex-1 2xl:text-2xl font-onest md:text-xl font-semibold">
          Inventory Stats
        </h2>
        <Link
          href="/inventory"
          className="text-xs flex-1 font-onest text-[var(--color-lightBlye)] text-left font-semibold underline"
        >
          See Inventory
        </Link>
      </div>
      {errorProfileLoad && (
        <div className="p-6 text-center text-sm font-onest text-red-400">
          {errorProfileLoad}
        </div>
      )}
      {loadingProfileData ? (
        <div className="flex w-full h-[160px] items-center justify-center">
          <div className="w-8 h-8 border-4 border-white/20 border-t-white rounded-full animate-spin" />
        </div>
      ) : (
        <>
          {/* Inventory stats grid */}
          <div className="grid gap-4 md:grid-cols-2 xl:grid-cols-4">
            <StatCard label="My Packs" primaryValue={homeData?.my_packs} />
            <StatCard label="Card Owned" primaryValue={homeData?.card_owned} />
            <StatCard
              label="Current Value"
              primaryValue={homeData?.current_value}
            />
            <StatCard
              label="Highest Value Card"
              primaryValue={homeData?.highest_value_card}
            />
          </div>

          {/* Quick stats header */}
          <div className="mt-6">
            <h2 className="text-lg font-onest font-semibold">Quick Stats</h2>
          </div>

          {/* Quick stats grid */}
          <div className="grid gap-4 md:grid-cols-2 xl:grid-cols-4 2xl:grid-cols-6">
            <StatCard
              label="Total Packs Opened"
              primaryValue={homeData?.pack_opened}
            />
            <StatCard
              label="All-time Cards Owned"
              primaryValue={homeData?.all_time_card_owned}
            />
            <StatCard label="Trades Made" primaryValue={homeData?.trade_made} />
            <StatCard
              label="Highest Trade Value"
              primaryValue={homeData?.highest_trade_value}
            />
            {/* <StatCard
              label="Free Spins Collected"
              primaryValue={homeData?.card_owned}
            />
            <StatCard
              label="Most Opened Brand"
              primaryValue={homeData?.most_opened_brand}
            /> */}
          </div>
        </>
      )}
    </div>
  );
};
