import React, { useState } from "react";
import CoinFlipHistory from "./CoinFlipHistory";
import RollHistory from "./RollHistory";
import CrashHistory from "./CrashHistory";
import SpinHistory from "./SpinHistory";
import SlabHistory from "./SlabHistory";

type GameTab = "coin flip" | "roll" | "crash" | "spin" | "slab";

const GamesRecord = () => {
  const [tab, setTab] = useState<GameTab>("coin flip");

  const handleTabChange = (value: GameTab) => {
    setTab(value);
  };

  return (
    <div>
      {/* Tabs UI – SAME AS YOUR DESIGN */}
      <div className="mt-4 flex flex-wrap gap-2 2xl:gap-4">
        {["coin flip", "roll", "crash", "spin", "slab"].map((item) => (
          <button
            key={item}
            onClick={() => handleTabChange(item as GameTab)}
            className={`px-4 md:px-12 2xl:px-16 py-2 md:py-3 font-extrabold transition-all text-xs uppercase 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
              tab === item
                ? " text-white !border-[var(--color-blue)]"
                : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-50"
            }`}
          >
            {item}
          </button>
        ))}
      </div>

      {/* Tab Content */}
      <div className="mt-6">
        {tab === "coin flip" && <CoinFlipHistory />}
        {tab === "roll" && <RollHistory />}
        {tab === "crash" && <CrashHistory />}
        {tab === "spin" && <SpinHistory />}
        {tab === "slab" && <SlabHistory />}
      </div>
    </div>
  );
};

export default GamesRecord;
