import { SlabAnalytics } from "@/app/games/mystery-packs/Inner";

function ValueRow({
  label,
  percent,
  slabAnalytics,
  slabLoading,
}: {
  label: string;
  percent: number;
  slabAnalytics: SlabAnalytics;
  slabLoading: boolean;
}) {
  return (
    <>
      {slabLoading ? (
        <div className="flex w-full h-20 items-center justify-center">
          <div className="w-8 h-8 border-4 border-white/20 border-t-white rounded-full animate-spin" />
        </div>
      ) : (
        <div className="grid font-onest grid-cols-[64px_1fr_44px] items-center gap-3 text-[#DBFAFF]">
          <span className="text-xs text-[#DBFAFF]">{label}</span>
          <div className="h-2 rounded-full bg-white/10 overflow-hidden">
            <div
              className="h-full bg-[#DBFAFF] rounded-full"
              style={{ width: `${Math.max(0, Math.min(100, percent))}%` }}
            />
          </div>
          <span className="text-xs text-[#DBFAFF] text-right">{percent}%</span>
        </div>
      )}
    </>
  );
}

export default ValueRow;
