"use client";
import React from "react";
import type { PackUI } from "./types";

export default function PackTabs({
  packs,
  activeId,
  onSelect,
  getSlabAnalytics,
}: {
  packs: PackUI[];
  activeId: number;
  onSelect: (id: number) => void;
  getSlabAnalytics: (amount: any) => void;
}) {
  return (
    <div className="grid grid-cols-2 gap-3">
      {packs.map((p) => {
        const active = p.id === activeId;
        return (
          <button
            key={p.id}
            onClick={() => {
              getSlabAnalytics(p.price);
              onSelect(p.id);
            }}
            className={`flex items-center gap-3 overflow-hidden relative flex-col border transition ${
              active
                ? "border-white/70 bg-[#121924]"
                : "border-[#151C29] bg-[#121924] hover:bg-[#101a2a]"
            }`}
          >
            <div className="absolute group-hover:w-40 bottom-10 left-1/2 -translate-x-1/2 w-16 h-12.5 group-hover:md:h-40 bg-[var(--color-blue)] group-hover:blur-xl transition-all duration-500 blur-3xl rounded-full opacity-50"></div>
            <img
              src={p.thumb}
              alt={p.title}
              className=" w-16 mt-3 object-contain"
            />
            <div className="p-4 bg-[#141d2b] text-white w-full -mt-10 relative bg-blur z-99999 flex items-center justify-center gap-4">
              <p className="text-white text-xs 2xl:text-base font-onest uppercase truncate">
                {p.title}
              </p>
            </div>
          </button>
        );
      })}
    </div>
  );
}
