import React from "react";
import Toggle from "../ui/toggle";
import { useSelector } from "react-redux";
import { User } from "@/constants/types";

type BoxItem = {
  id: number;
  name: string;
  price: string;
  image: string;
};

type ToggleProps = {
  checked?: boolean;
  setBoltMode?: (val: boolean) => void;
  className?: string;
  box?: BoxItem;
};
const OgBox = ({ checked, setBoltMode, className = "", box }: ToggleProps) => {
  const user = useSelector((state: any) => state.auth.user) as User | null;

  return (
    <div className="container mx-auto">
      <div className="flex items-center flex-col md:flex-row gap-5 my-3 md:my-3 2xl:my-8 bg justify-between px-5 md:px-8 py-4 md:py-6 ">
        <div className="flex gap-5">
          <button className="flex items-center gap-2 text-white italic hover:scale-105 duration-300 transition-all font-extrabold font-sofia">
            <span>&lt; BACK</span>
          </button>

          <div className="flex items-center gap-4">
            <div className="relative md:w-full ">
              <img
                src={box?.image ?? "/images/mystery-bozes/blue.svg"}
                alt="Box"
                className="w-10 md:w-20 object-contain"
              />
            </div>
            <div>
              <h1 className="text-lg md:text-2xl w-full md:min-w-40 italic font-sofia font-black text-white">
                {box?.name}
              </h1>
              <span className="text-(--color-pink) flex items-center w-full gap-1 text-xs font-sofia italic md:text-xl font-bold">
                {!user ? (
                  <img
                    src="/images/header/win.svg"
                    alt=""
                    className="h-4 w-4"
                  />
                ) : (
                  <>
                    {user?.activeMode === "coins" ? (
                      <img
                        src="/images/header/win.svg"
                        alt=""
                        className="h-4 w-4"
                      />
                    ) : (
                      <img
                        src="/images/header/star.svg"
                        alt=""
                        className="h-4 w-4"
                      />
                    )}
                  </>
                )}
                {box?.price}
              </span>
            </div>
          </div>
        </div>

        <div className="flex items-center gap-2">
          <img src="/images/hero/star.png" alt="" />
          <span className="italic font-sofia font-extrabold text-xs text-[15px] text-[var(--color-slate)]">
            BOLTMODE
          </span>
          <Toggle checked={checked} onChange={(next) => setBoltMode?.(next)} />
        </div>
      </div>
    </div>
  );
};

export default OgBox;
