const MysteryHeader = ({ onBack }: { onBack?: () => void }) => {
  return (
    <div className="bg-[#161E2A] overflow-hidden scrollbar-hide p-5 mt-4 flex items-center flex-col md:flex-row gap-4 justify-between w-full">
      <div className="flex gap-3 md:gap-7 items-start">
        <button
          onClick={onBack}
          className="cursor-pointer text-xs md:text-sm p-2 min-w-15 px-4 font-extrabold text-white bg-(--color-darkBlue) hover:text-white italic transition"
        >
          &lt; BACK
        </button>
        <div className="flex flex-col gap-3">
          <h1 className="italic font-extrabold font-sofia text-sm md:text-2xl">
            TCGWIN MYSTERY SLABS
          </h1>
          <p className="max-w-87.5 font-normal font-onest leading-5 text-sm md:text-lg 2xl:text-2xl">
            Choose packs from different price levels & unpack mystery slabs
          </p>
        </div>
      </div>
      <div className="flex relative -mb-14 items-center">
        <div className="absolute bottom-17 left-1/2 -translate-x-1/2 w-37.5 md:w-117.5 h-50 md:h-62.5 bg-[#2B5AFF] blur-3xl rounded-full opacity-50"></div>
        <img
          src="/images/mystery-packs/1.svg"
          className="w-20 md:w-40.75 object-contain -rotate-5 mt-3 -mr-7 relative z-10 h-59"
          alt=""
        />
        <img
          src="/images/mystery-packs/2.svg"
          className="w-20 md:w-40.75 object-contain -mx-2 relative z-10 h-59"
          alt=""
        />
        <img
          src="/images/mystery-packs/3.svg"
          className="w-20 md:w-40.75 object-contain -mx-2 relative z-10 h-59"
          alt=""
        />
        <img
          src="/images/mystery-packs/5.svg"
          className="w-16 md:w-20 object-contain rotate-15 blur-[2px] z-10 absolute -left-10 -bottom-16 h-59"
          alt=""
        />
        <img
          src="/images/mystery-packs/5.svg"
          className="w-16 md:w-20 object-contain blur-[2px] z-20 absolute left-1/2 -translate-x-1/2 -bottom-20 h-[236px]"
          alt=""
        />
        <img
          src="/images/mystery-packs/5.svg"
          className="w-16 md:w-20 object-contain blur-[2px] z-20 absolute -right-4 -bottom-20 h-[236px]"
          alt=""
        />
        <img
          src="/images/mystery-packs/4.svg"
          className="w-20 md:w-[163px] object-contain rotate-5 mt-3 -ml-7 relative z-0 h-[236px]"
          alt=""
        />
      </div>
    </div>
  );
};

export default MysteryHeader;
