"use client";
import React from "react";

interface AddedToInventoryProps {
  image: string;
  title: string;
  subtitle: string;
  onBuyAnother: () => void;
  onClose: () => void;
}

const AddedToInventory: React.FC<AddedToInventoryProps> = ({
  image,
  title,
  subtitle,
  onBuyAnother,
  onClose,
}) => {
  return (
    <>
      <h1 className="mx-auto w-full text-sm md:text-base 2xl:text-lg flex items-center gap-3 justify-center animate-fade-in">
        <div className="flex bg-[#2B5AFF26] rounded-full items-center justify-center w-7 font-bold h-7">
          <img src="/images/mystery-packs/tick.svg" alt="" />
        </div>
        <span>Added to inventory</span>
      </h1>

      <img
        src={image}
        className="relative w-32 md:w-48 z-10 mt-5 mx-auto animate-fade-in"
        style={{ animationDelay: "0.2s" }}
        alt=""
      />

      <h1
        className="text-center mt-3 uppercase text-base md:text-xl 2xl:text-2xl font-bold text-white z-10 relative animate-fade-in"
        style={{ animationDelay: "0.4s" }}
      >
        {title}
      </h1>

      <h1
        className="text-center uppercase text-base md:text-xl 2xl:text-2xl font-bold text-white z-10 relative animate-fade-in"
        style={{ animationDelay: "0.5s" }}
      >
        {subtitle}
      </h1>

      <div
        className="flex justify-center mt-5 md:mt-10 relative z-10 items-center gap-3 animate-fade-in"
        style={{ animationDelay: "0.6s" }}
      >
        <button
          onClick={onBuyAnother}
          className="hover:border-white duration-300 hover:bg-transparent border-transparent border bg-[#4D4CFE] px-4 py-1.5 font-bold text-xs md:text-base md:py-2 md:px-8"
        >
          Buy Another
        </button>

        <button
          onClick={onClose}
          className="border duration-300 hover:border-transparent hover:bg-[#4D4CFE] px-4 py-1.5 font-bold text-xs md:text-base md:py-2 md:px-8"
        >
          Close
        </button>
      </div>
    </>
  );
};

export default AddedToInventory;
