import Image from "next/image";
import React from "react";
// ---- Card component ----
type TradeCardProps = {
  card: TradeCardItem;
  onClick: () => void;
  isRemoving?: boolean;
  isSelected?: boolean; // ✅ NEW
};
export type InventoryBrand = "MTG" | "Pokemon" | "Lorcana";
export type TradeCardItem = {
   id: string;
   name: string;
   price: number;
   status: string;
   rarity: string;
   probability: string;
   locked: number;
   brand: InventoryBrand;
   markup: number | null;
   pack_name: string;
   image: string;
   inv_id: number;
   count?: number;
};
const TradeCard: React.FC<TradeCardProps> = ({
  card,
  onClick,
  isRemoving = false,
  isSelected = false, //
}) => {
  return (
    <div
      onClick={onClick}
      className={`relative group cursor-pointer border border-[#151C29] px-4 pt-4 pb-6 flex duration-300 flex-col items-center hover:border-[#2B5AFF] transition-all ${
        isRemoving ? "animate-slideOut" : ""
      } ${isSelected ? "ring-2 ring-[var(--color-blue)]" : ""}`}
      style={{
        animation: isRemoving ? "slideOut 0.5s ease-out forwards" : "none",
      }}
    >
      {isSelected && (
        <div className="absolute bottom-0 left-0 w-full shadow-lg">
          <div className="flex items-center w-full gap-2">
            <div className="bg-[var(--color-blue)] p-3">
              <img
                src="/images/coinFlip/modal/tick.svg"
                alt="tick"
                className="w-3 h-3"
              />
            </div>
          </div>
        </div>
      )}
      <div className="absolute z-10 group-hover:w-40 bottom-10 left-1/2 -translate-x-1/2 w-[120px] h-[100px] 2xl:h-[180px] group-hover:md:h-[100px] bg-[var(--color-blue)] group-hover:blur-xl transition-all duration-500 blur-2xl rounded-full opacity-50"></div>

      <div className="absolute  transiton-all duration-500 top-3 left-3 bg-[var(--color-gray)] px-3 text-[#DBFAFF] rounded-full text-sm font-semibold">
        40
      </div>
      {/* Card image */}
      <div className="w-20 h-24 relative z-20 2xl:w-[110px] 2xl:h-[153px]">
        <Image
          src={card.image}
          width={110}
          height={153}
          alt={card.name}
          className="w-full h-full group-hover:rotate-3 transition-all object-contain transform duration-500"
        />
      </div>

      {/* Text under image */}
      <div className="mt-4 relative z-20 text-center">
        <p className="text-[10px] leading-2 md:text-base font-sofia text-[#4D4CFE] ">
          {card.rarity}
        </p>
        <p className="text-sm md:text-xl font-extrabold font-sofia">
          {card.name.split(" ").slice(0, 2).join(" ")}
        </p>
      </div>
      {/* {card.price === "$11.90" ? (
        <div className="w-full">
          <div className="mt-3 flex relative justify-between z-20 w-20 items-center gap-2 bg-[#13151A] px-2 py-1 mb-3 font-sofia">
            <span className="text-xs text-[#DBFAFF] font-onest">$</span>

            <span className="text-sm md:text-base text-[#DBFAFF]  font-extrabold">
              3
            </span>

            <button type="button" className="ml-1">
              <img
                src="/images/list/edit.svg"
                className="w-4"
                alt="edit price"
              />
            </button>
          </div>
          <button className="mb-2 !w-full border border-white text-center py-1">
            DELIST
          </button>
        </div>
      ) : ( */}
        <button className=" text-sm leading-3 md:text-xl font-extrabold text-white font-sofia">
          {card.price}
        </button>
      {/* )} */}
    </div>
  );
};

export default TradeCard;
