"use client";

import React from "react";
import Image from "next/image";

type ParentTab = "cards" | "packs";
type ChildTab = "all" | "magic" | "pokemon" | "lorcana" | "slab";
type BrandCounts = {
  magic: number;
  pokemon: number;
  lorcana: number;
  slab: number;
};
type Props = {
  parentTab: ParentTab;
  setParentTab: (tab: ParentTab) => void;

  childTab: ChildTab;
  setChildTab: (tab: ChildTab) => void;

  search: string;
  setSearch: (value: string) => void;
  brandCounts: BrandCounts;
  showAllBrands: boolean;
  onBack?: () => void; // optional if you want back navigation
  fetchCards: () => void;
  onLockSelected: () => void;
  hasLockedCards: boolean;
  isLockedAll: boolean;
};

const InventoryHeader: React.FC<Props> = ({
  parentTab,
  setParentTab,
  childTab,
  setChildTab,
  search,
  setSearch,
  brandCounts,
  onBack,
  showAllBrands,
  fetchCards,
  onLockSelected,
  isLockedAll,
  hasLockedCards,
}) => {
  return (
    <div className="z-10">
      <div className="container mx-auto py-4">
        {/* Parent Tabs */}
        <div className="flex gap-2 md:gap-4 my-3 2xl:my-6">
          <button
            onClick={() => {
              fetchCards();
              setParentTab("cards");
              setChildTab("all");
            }}
            className={`px-3 md:px-4 2xl:px-6 py-1 md:py-2 2xl:py-3 font-extrabold text-xs md:text-sm font-sofia 2xl:text-2xl transition-all ${
              parentTab === "cards"
                ? "bg-[var(--color-blue)] text-white"
                : "text-[var(--color-slate)] hover:bg-gray-700"
            }`}
          >
            CARDS
          </button>

          <button
            onClick={() => {
              setParentTab("packs");
              setChildTab("all");
            }}
            className={`px-3 md:px-4 2xl:px-6 py-1 md:py-2 2xl:py-3 font-extrabold text-xs md:text-sm font-sofia 2xl:text-2xl transition-all ${
              parentTab === "packs"
                ? "bg-[var(--color-blue)] text-white"
                : "text-[var(--color-slate)] hover:bg-[var(--color-gray)]"
            }`}
          >
            PACKS
          </button>
        </div>

        {/* Child Tabs + Search */}
        <div className="flex flex-col md:flex-row items-center gap-3 justify-between">
          <div className="flex flex-wrap gap-2 2xl:gap-4">
            {showAllBrands && (
              <button
                onClick={() => setChildTab("all")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-(--color-naviBlue) border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "all"
                    ? "text-white !border-[var(--color-blue)]"
                    : "text-(--color-slate) border-transparent cursor-pointer hover:opacity-100 hover:bg-(--color-gray) opacity-60"
                }`}
              >
                ALL BRANDS
              </button>
            )}

            {brandCounts.magic > 0 && (
              <button
                onClick={() => setChildTab("magic")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-(--color-naviBlue) border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "magic"
                    ? "text-white !border-[var(--color-blue)]"
                    : "text-(--color-slate) border-transparent cursor-pointer hover:opacity-100 hover:bg-(--color-gray) opacity-60"
                }`}
              >
                <span className="flex items-center gap-2">
                  <Image
                    width={117}
                    height={37}
                    src="/images/inventory/magic.svg"
                    alt="magic"
                    className="w-12 md:w-full"
                  />
                </span>
              </button>
            )}

            {brandCounts.pokemon > 0 && (
              <button
                onClick={() => setChildTab("pokemon")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-(--color-naviBlue) border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "pokemon"
                    ? "text-white !border-[var(--color-blue)]"
                    : "text-(--color-slate) border-transparent cursor-pointer hover:opacity-100 hover:bg-(--color-gray) opacity-60"
                }`}
              >
                <Image
                  width={117}
                  height={37}
                  src="/images/inventory/pokemon.svg"
                  alt="pokemon"
                  className="w-12 md:w-full"
                />
              </button>
            )}

            {brandCounts.lorcana > 0 && (
              <button
                onClick={() => setChildTab("lorcana")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-(--color-naviBlue) border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "lorcana"
                    ? "text-white !border-[var(--color-blue)]"
                    : "text-(--color-slate) border-transparent cursor-pointer hover:opacity-100 hover:bg-(--color-gray) opacity-60"
                }`}
              >
                <Image
                  width={117}
                  height={37}
                  src="/images/inventory/lorcana.svg"
                  alt="lorcana"
                  className="w-12 md:w-full"
                />
              </button>
            )}

            {brandCounts.slab > 0 && (
              <button
                onClick={() => setChildTab("slab")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-(--color-naviBlue) border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "slab"
                    ? "text-white !border-[var(--color-blue)]"
                    : "text-(--color-slate) border-transparent cursor-pointer hover:opacity-100 hover:bg-(--color-gray) opacity-60"
                }`}
              >
                {/* <Image
                width={117}
                height={37}
                src="/images/inventory/lorcana.svg"
                alt="slab"
                className="w-12 md:w-full"
              /> */}
                Slab
              </button>
            )}
          </div>
          <div className="flex items-center gap-3">
            {hasLockedCards && (
              <button
                onClick={onLockSelected}
                className="transition-all duration-300 px-2 md:px-5 border text-[10px] md:text-sm hover:bg-white hover:text-(--color-blue) border-white font-onest py-2 font-bold"
              >
                UNLOCK ALL
              </button>
            )}

            <input
              type="text"
              placeholder="SEARCH ITEMS"
              value={search}
              onChange={(e) => setSearch(e.target.value)}
              className="text-[#DBFAFF] py-1 md:py-2 text-base md:text-lg 2xl:text-2xl font-sofia border border-[#29313D] px-5 md:min-w-62.5 outline-none focus:outline-none focus:ring-0"
            />
          </div>
        </div>
      </div>
    </div>
  );
};

export default InventoryHeader;
