"use client";

import { User } from "@/constants/types";

type ChildTab = "all" | "magic" | "pokemon" | "lorcana" | "slab";

type InventoryActionBarProps = {
  childTab: ChildTab;
  selectedCount: number;
  selectedItemCount: number;
  allOnScreenCount: number;
  totalValue: string;
  onSelectAll: () => void;
  onLockSelected: () => void;
  onSell: () => void;
  isLockedAll: boolean;
  user: User;
};

export default function InventoryActionBar({
  selectedCount,
  allOnScreenCount,
  totalValue,
  onSelectAll,
  onLockSelected,
  onSell,
  selectedItemCount,
  isLockedAll,
  childTab,
  user,
}: InventoryActionBarProps) {
  if (selectedCount === 0) return null; // kuch select nahi to bar hi mat dikhao

  const allSelected = selectedItemCount === allOnScreenCount;
  const showClearSelection =
    childTab === "all" &&
    selectedItemCount === allOnScreenCount &&
    allOnScreenCount > 0;

  return (
    <>
      {/* {selectedCount !== 0 && (  */}
      {Number(totalValue) !== 0 && (
        <div className="fixed max-w-[96%] left-0 z-[9999] container mx-auto right-0 bottom-2 ">
          <div className="">
            <div className="box-shadow-custom bg-(--color-naviBlue) px-2 md:px-4 py-4 flex items-center flex-col md:flex-row justify-between gap-4 text-xs md:text-sm 2xl:text-base font-sofia">
              {/* Left side */}
              <div className="flex items-center gap-2 md:gap-3">
                <div className="pl-0 px-3 py-2 text-xs md:text-xl font-sofia 2xl:text-3xl font-extrabold">
                  {selectedCount} CARDS SELECTED
                </div>

                <button
                  onClick={onSelectAll}
                  //  disabled={parentTab !== "cards"}
                  className="px-2 md:px-5 py-2 text-[10px] md:text-sm bg-white hover:text-white border border-transparent hover:border-white transition-all duration-300 text-(--color-blue) font-onest hover:bg-[#1f2433] font-medium"
                >
                  {allSelected ? "DESELECT ALL" : "SELECT ALL"}
                </button>

                <button
                  onClick={onLockSelected}
                  className="transition-all duration-300 px-2 md:px-5 border text-[10px] md:text-sm hover:bg-white hover:text-(--color-blue) border-white font-onest py-2 font-bold"
                >
                  {isLockedAll ? "UNLOCKED SELECTED" : "LOCK SELECTED"}
                </button>
              </div>

              {/* Right side */}
              <div className="flex items-center gap-3">
                <div className="text-right">
                  <div className="text-[10px] font-sofia font-bold text-xs 2xl:text-base ">
                    TOTAL VALUE
                  </div>
                  <div className="text-[var(--color-blue)] flex items-center gap-1 font-extrabold text-sm font-sofia md:text-2xl">
                    {user?.activeMode === "coins" ? (
                      <img
                        src="/images/header/win.svg"
                        alt=""
                        className="h-4 w-4"
                      />
                    ) : (
                      <img
                        src="/images/header/star.svg"
                        alt=""
                        className="h-4 w-4"
                      />
                    )}
                    {totalValue}
                  </div>
                </div>

                <button
                  disabled={Number(totalValue) === 0}
                  onClick={onSell}
                  className="px-4 py-2 bg-[var(--color-blue)] font-sofia hover:bg-[#5d5cff] font-onest text-[10px] md:text-sm 2xl:text-base"
                >
                  SELL CARDS
                </button>
              </div>
            </div>
          </div>
        </div>
        )}
      {/* )} */}
    </>
  );
}
