"use client";

import Image from "next/image";
import { useEffect, useState } from "react";
import { InternalButton } from "../ui/Button";
import { OddsList } from "./OddsList";
type Brand = "magic" | "pokemon" | "lorcana";
type CardDrop = {
  id: string;
  title: string;
  subtitle: string;
  brand: Brand;
  date: string;
  price: number;
  image: string;
};

type Props = {
  card: CardDrop | null;
  onClose: () => void; // parent me setDetailCard(null)
};

export default function DetailSidebar({ card, onClose }: Props) {
  const [isOpen, setIsOpen] = useState(false);

  // card aaye to drawer open animation
  useEffect(() => {
    if (card) {
      setIsOpen(true);
    }
  }, [card]);

  if (!card) return null;

  const handleClose = () => {
    // slide out
    setIsOpen(false);
    // animation duration (300ms) ke baad parent ko close
    setTimeout(() => {
      onClose();
    }, 300);
  };

  return (
    <div className="fixed inset-0 z-[99998] flex justify-end">
      {/* BACKDROP */}
      <div
        className={`
          flex-1  transition-transform cursor-pointer duration-500 ease-out
          ${isOpen ? " translate-x-0" : " translate-x-100"}
        `}
        onClick={handleClose}
        aria-hidden="true"
      />

      {/* PANEL */}
      <div
        className={`
          relative w-full max-w-md bg-[#10131B] h-full shadow-2xl
          transform transition-transform duration-500 ease-out
          ${isOpen ? "translate-x-0" : "translate-x-full"}
          `}
      >
        {/* back btn */}
        <div className="flex font-sofia mt-3 px-4 items-center gap-3">
          <button
            onClick={handleClose}
            className="self-start text-[10px] cursor-pointer px-3 py-1 bg-[var(--color-gray)] text-white font-bold"
            
          >
            &lt; BACK
          </button>
        </div>
        <div className="flex items-center justify-center h-full">
          <div className="flex flex-col items-center justify-center text-center font-sofia h-full w-full px-6 ">
            {/* Scrollable content should not shrink height */}
            <div className="flex flex-col items-center justify-center w-full max-h-full ">
              {/* big card */}
              <div className="relative md:mb-8">
                <div className="w-[150px] 2xl:w-[150px] h-[170px] 2xl:h-[200px] mx-auto flex items-center justify-center">
                  <Image
                    src="/images/fairness/img.svg"
                    alt={card.image}
                    width={200}
                    height={280}
                    className="w-40 h-[250px] object-contain rotate-swing"
                  />
                </div>
              </div>

              <div className="flex items-center mt-5 gap-3">
                <button className="rounded-full py-2 px-5 font-onest text-xs bg-[var(--color-gray)] hover:border-[var(--color-gray)]  hover:bg-[var(--color-naviBlue)]">
                  view set
                </button>
                <button className="rounded-full py-2 px-5 font-onest text-xs bg-[var(--color-gray)] hover:border-[var(--color-gray)]  hover:bg-[var(--color-naviBlue)]">
                  Shop
                </button>
              </div>

              <div className="mt-2 text-xs md:text-xl 2xl:text-3xl text-[var(--color-blue)] font-bold uppercase">
                ODDS
              </div>

              <div className="text-lg md:text-xl 2xl:text-3xl font-extrabold uppercase">
                {card.title}
              </div>

              <div className="text-xl md:text-2xl font-extrabold text-white">
                {card.price}
              </div>

              <OddsList />
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
