// packs.data.ts
export type PackValueRange = {
  label: string; // "5-15"
  percent: number; // 36
};

export type ChaseSlab = {
  id: string;
  title: string;
  subtitle?: string;
  priceCoins: number;
  image: string;
};

export type MysteryPack = {
  id: string;
  title: string;
  price: string;
  image: string; // big pack image
  thumb: string; // small pack image for tabs
  averageValue: number; // e.g. 25
  valueRanges: PackValueRange[];
  chaseSlabs: ChaseSlab[];
};

export const SLABPACKS: MysteryPack[] = [
  {
    id: "basic",
    title: "BASIC MYSTERY SLAB PACK",
    price: "1,000",
    image: "/packs/basic-big.png",
    thumb: "/packs/basic-thumb.png",
    averageValue: 25,
    valueRanges: [
      { label: "5-15", percent: 36 },
      { label: "15-30", percent: 34 },
      { label: "30-100", percent: 22 },
      { label: "100-250", percent: 6.5 },
      { label: "250-300", percent: 4.5 },
      { label: "300-450", percent: 0.5 },
    ],
    chaseSlabs: Array.from({ length: 15 }).map((_, i) => ({
      id: `basic-chase-${i}`,
      title: "GLACEON EX",
      subtitle: "SPECIAL WHATEVER • 10 GRADE",
      priceCoins: 450,
      image: "/cards/glaceon.png",
    })),
  },
  {
    id: "pro",
    title: "PRO MYSTERY SLAB PACK",
    price: "$2,500",
    image: "/packs/pro-big.png",
    thumb: "/packs/pro-thumb.png",
    averageValue: 60,
    valueRanges: [
      { label: "20-40", percent: 28 },
      { label: "40-80", percent: 35 },
      { label: "80-200", percent: 22 },
      { label: "200-400", percent: 10 },
      { label: "400-600", percent: 4.5 },
      { label: "600-900", percent: 0.5 },
    ],
    chaseSlabs: Array.from({ length: 12 }).map((_, i) => ({
      id: `pro-chase-${i}`,
      title: "CHARIZARD V",
      subtitle: "ALT ART • 10 GRADE",
      priceCoins: 900,
      image: "/images/mystery-packs/chaseSlab.svg",
    })),
  },
  {
    id: "gold",
    title: "GOLD MYSTERY SLAB PACK",
    price: "$5,000",
    image: "/packs/gold-big.png",
    thumb: "/packs/gold-thumb.png",
    averageValue: 120,
    valueRanges: [
      { label: "50-100", percent: 30 },
      { label: "100-200", percent: 35 },
      { label: "200-400", percent: 22 },
      { label: "400-700", percent: 9 },
      { label: "700-900", percent: 3.5 },
      { label: "900-1200", percent: 0.5 },
    ],
    chaseSlabs: Array.from({ length: 10 }).map((_, i) => ({
      id: `gold-chase-${i}`,
      title: "RAYQUAZA VMAX",
      subtitle: "SECRET • 10 GRADE",
      priceCoins: 1200,
      image: "/cards/rayquaza.png",
    })),
  },
  {
    id: "elite",
    title: "ELITE MYSTERY SLAB PACK",
    price: "$10,000",
    image: "/packs/elite-big.png",
    thumb: "/packs/elite-thumb.png",
    averageValue: 250,
    valueRanges: [
      { label: "100-200", percent: 25 },
      { label: "200-350", percent: 35 },
      { label: "350-600", percent: 23 },
      { label: "600-1000", percent: 12 },
      { label: "1000-1500", percent: 4.5 },
      { label: "1500-2500", percent: 0.5 },
    ],
    chaseSlabs: Array.from({ length: 8 }).map((_, i) => ({
      id: `elite-chase-${i}`,
      title: "GENGAR VMAX",
      subtitle: "ALT ART • 10 GRADE",
      priceCoins: 2500,
      image: "/cards/gengar.png",
    })),
  },
];

export type BoxItem = {
  id: number;
  name: string;
  price: string;
  image: string;
};

export const BOXES: BoxItem[] = [
  {
    id: 1,
    name: "TCGWIN OG BOX",
    price: "2,00",
    image: "/images/mystery-bozes/blue.svg",
  },
  {
    id: 2,
    name: "FYREBOX",
    price: "1,000",
    image: "/images/mystery-bozes/yellow.svg",
  },
  {
    id: 3,
    name: "ICECOLD",
    price: "5,00",
    image: "/images/mystery-bozes/lightBlue.svg",
  },
  {
    id: 4,
    name: "SILVERBOX",
    price: "2,000",
    image: "/images/mystery-bozes/img.svg",
  },
  {
    id: 5,
    name: "ICECOLD",
    price: "1,00",
    image: "/images/mystery-bozes/lightBlue.svg",
  },
  {
    id: 6,
    name: "SILVERBOX",
    price: "3,00",
    image: "/images/mystery-bozes/img.svg",
  },
];
