// app/components/PlayersList.tsx
import Image from "next/image";
import { useEffect, useState } from "react";

type Player = {
  userId: string;
  name: string;
  image?: string;
  cards?: any[];
  totalQty?: number;
  totalPrice?: number;
};

export default function PlayersList({ players }: { players: any[] }) {
  if (!Array.isArray(players)) return null;
  useEffect(() => {}, []);

  return (
    <div className="w-full max-w-sm md:absolute max-h-55 2xl:max-h-75 overflow-y-auto scrollbar-hide z-9999 md:left-2 md:top-2">
      {/* bg-[var(--color-darkBlue)] */}
      <div className=" overflow-hidden">
        {players.map((p, idx) => (
          <button
            key={idx}
            className={[
              "group w-full text-left",
              "flex items-center bg-(--color-darkBlue) justify-between gap-4",
              "px-2 py-2",
              "border-b border-(--color-gray) last:border-b-0",

              "hover:bg-(--color-gray) transition-colors",
            ].join(" ")}
          >
            {/* Left: avatar + name */}
            <div className="flex items-center gap-4">
              <div className="relative h-7 w-7 rounded-full overflow-hidden ring-1 ring-white/10">
                <Image
                  src={p?.image}
                  alt={p?.name ? `${p.name} avatar` : "Player avatar"}
                  fill
                  className="object-cover"
                />
              </div>

              <div className="leading-none">
                <div className="text-white font-extrabold tracking-wide italic">
                  {p?.price}
                </div>
              </div>
            </div>

            {/* Right: card image */}
            <div className="relative h-10 w-7  img-border-radius overflow-hidden ring-1 ring-white/10 shadow-[0_8px_24px_rgba(0,0,0,0.45)]">
              <Image
                // src={p?.cards?.[0]?.image || "/images/crash/img.svg"}
                src="/images/crash/img.svg"
                alt="Player card"
                fill
                className="object-cover group-hover:scale-[1.02] transition-transform"
              />
            </div>
          </button>
        ))}
      </div>
    </div>
  );
}
