"use client";

import Image from "next/image";
import { useRouter } from "next/navigation";
import { RollSlider } from "../Home2/RollSlider";
import "./../../components/home/style.css";

type Game = {
  id: string;
  label: string;
  href: string; // ✅ add this
  bgSrc: string;
  img1: string;
  img2: string;
  img3: string;
  fgClassName?: string;
};

const games: Game[] = [
  {
    id: "roll",
    label: "ROLL",
    href: "/games/roll",
    bgSrc: "/images/home/bg.svg",
    img1: "/images/home/slide2.svg",
    img2: "/images/home/slide1.svg",
    img3: "/images/home/slide3.svg",

    fgClassName: "",
  },
  {
    id: "crash",
    label: "CRASH",
    href: "/games/crash",
    bgSrc: "/images/home/bg.svg",
    img1: "/images/home/crashImg.svg",
    img2: "/images/home/v.svg",
    img3: "/images/home/crash.svg",
    fgClassName: "",
  },
  {
    id: "coinflip",
    label: "COINFLIP",
    href: "/games/coinflip",
    bgSrc: "/images/home/bg.svg",
    img1: "/images/home/slide1.svg",
    img2: "/images/home/slide1.svg",
    img3: "/images/home/slide1.svg",
    fgClassName: "",
  },
  // {
  //   id: "mystery",
  //   label: "MYSTERY SLABS",
  //   href: "/games/mystery-packs",
  //   bgSrc: "/images/home/bg.svg",
  //   img1: "/images/home/slide1.svg",
  //   img2: "/images/home/slide1.svg",
  //   img3: "/images/home/slide1.svg",
  //   fgClassName: "",
  // },
];

export default function GameModes({ closeGames }: any) {
  const router = useRouter();
  return (
    <section className="w-full mt-2.5 py-10">
      <div className="">
        <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-4">
          {games.map((game) => (
            <button
              key={game.id}
              onClick={() => {
                closeGames();
                router.push(game.href);
              }}
              className="group cursor-pointer flex flex-col items-center text-center focus:outline-none"
            >
              {/* CARD */}
              <div className="relative w-full h-[180px] overflow-hidden rounded-md shadow-lg shadow-black/50 transition-all duration-300 ">
                {/* BG (same) */}
                <Image
                  src={game.bgSrc}
                  alt=""
                  fill
                  className={`${
                    game.id === "crash" && "group-hover:scale-115"
                  } object-cover transition-transform duration-500 ease-out`}
                  priority
                />

                {/* optional dark overlay */}
                <div className="" />
                {game.id === "roll" && (
                  <>
                    <RollSlider
                      img1="/images/home/purple.svg"
                      img2="/images/home/green.svg"
                      img3="/images/home/yellow.svg"
                    />
                    <div className="absolute bottom-10 left-1/2 -translate-x-1/2 flex items-center justify-center">
                      <Image
                        src="/images/home/cursor.svg"
                        alt={game.label}
                        width={220}
                        height={220}
                        className={`w-[38px] h-[45px] pointer-events-none select-none object-contain transition-transform duration-300 group-hover:scale-[1.03] `}
                      />
                    </div>
                  </>
                )}
                {game.id === "crash" && (
                  <>
                    <img
                      src="/images/home/crash.svg"
                      alt=""
                      className="relative object-contain group-hover:object-cover w-full z-0"
                    />

                    {/* V IMAGE (ON TOP OF crash.svg) */}
                    <img
                      src="/images/home/v.svg"
                      alt=""
                      className="absolute w-40 2xl:w-56 top-5 left-10 z-30"
                    />

                    {/* BADGE (TOP MOST) */}
                    <div className="absolute top-0 left-1/2 -translate-x-1/2 z-40 mt-7">
                      <div
                        className="
        transition-all duration-500
        group-hover:translate-y-44
        group-hover:rotate-[360deg]
      "
                      >
                        <div className="flex items-center flex-col text-white p-3 w-[45px] h-[45px] rounded-full bg-black">
                          <img
                            src="/images/home/crashImg.svg"
                            className="-mt-5"
                            alt=""
                          />
                          <p className="font-sofia uppercase text-xs">2.0x</p>
                        </div>
                      </div>
                    </div>
                    <div className="absolute transition-all duration-500 group-hover:-translate-y-4  top-0 blur-[1px] left-0 -translate-x-1/2 z-40 mt-7">
                      <img
                        src="/images/home/crash1.svg"
                        className="rotate-30 w-20"
                        alt=""
                      />
                    </div>
                    <div
                      className={`transition-all duration-500 group-hover:-translate-y-4 absolute top-20 transform md:text-[90px] 2xl:text-[100px] !my-p !py-0 font-black text-transparent opacity-20 !font-onest select-none pointer-events-none heading font-onest `}
                    >
                      CRASH
                    </div>
                    <div className="absolute -bottom-14 blur-[1px] group-hover:translate-x-1 transition-all duration-500 group-hover:-translate-y-4 right-0 -translate-x-1/2 z-40 mt-7">
                      <img
                        src="/images/home/crash1.svg"
                        className="rotate-60 w-20"
                        alt=""
                      />
                    </div>
                  </>
                )}
                {game.id === "coinflip" && (
                  <>
                    {/* BADGE (TOP MOST) */}
                    <div className="absolute top-3 left-1/2 -translate-x-1/2 z-40 mt-7">
                      <div
                        className="
        transition-all duration-500
        group-hover:scale-115
        
      "
                      >
                        <div className="flex items-center flex-col text-white p-3 ">
                          <img
                            src="/images/home/centerC.svg"
                            className="-mt-5"
                            alt=""
                          />
                        </div>
                      </div>
                    </div>
                    <div className="absolute top-0 right-6 -translate-x-1/2 z-30 mt-7">
                      <div
                        className="
        transition-all duration-500
        group-hover:scale-115
        group-hover:-translate-y-4
        group-hover:translate-x-4
      "
                      >
                        <div className="flex items-center flex-col text-white p-3 ">
                          <img
                            src="/images/home/c3.svg"
                            className="-mt-5"
                            alt=""
                          />
                        </div>
                      </div>
                    </div>

                    <div className="absolute top-18 left-28 -translate-x-1/2 z-30 mt-7">
                      <div
                        className="
        transition-all duration-500
        group-hover:scale-115
        group-hover:translate-y-4
        group-hover:-translate-x-4
      "
                      >
                        <div className="flex items-center flex-col text-white p-3 ">
                          <img
                            src="/images/home/c1.svg"
                            className="-mt-5"
                            alt=""
                          />
                        </div>
                      </div>
                    </div>
                    <div className="absolute top-3 left-1/2 -translate-x-1/2  z-30 mt-7">
                      <div
                        className="
        transition-all duration-500
        group-hover:scale-115
        group-hover:-translate-y-8
        group-hover:-translate-x-32
      "
                      >
                        <div className="flex items-center flex-col text-white p-3 ">
                          <img
                            src="/images/home/c1.svg"
                            className="-mt-5"
                            alt=""
                          />
                        </div>
                      </div>
                    </div>

                    <div className="absolute -bottom-24 blur-[1px] transition-all duration-500 group-hover:-translate-y-14 -right-10 -translate-x-1/2 z-40 ">
                      <img src="/images/home/c3.svg" className=" w-20" alt="" />
                    </div>
                  </>
                )}
                {game.id === "mystery" && (
                  <>
                    <div className="flex mt-5 justify-center items-center ">
                      <img
                        src="/images/roll/left.webp"
                        className="w-14 md:w-[53px] blur-[2px] object-contain -rotate-14  relative z-50 -mr-3 "
                        alt=""
                      />

                      <div className="relative flex  h-full">
                        <img
                          src="/images/home/m3.svg"
                          className="w-16 md:w-[63px] object-contain -rotate-12  z-50 absolute -left-12 group-hover:translate-x-0 duration-500 transition-all translate-x-16 -mt-2 md:mt-0 -translate-y-[1px] top-5  "
                          alt=""
                        />

                        <img
                          src="/images/home/m1.svg"
                          className="w-20 md:w-[85px] object-contain relative z-99 "
                          alt=""
                        />

                        <img
                          src="/images/home/m2.svg"
                          className="w-16 md:w-[63px] -mt-2 md:mt-0 group-hover:translate-x-0 duration-500 transition-all -translate-x-12  group-hover:rotate-14 object-contain -ml-3  z-60 absolute -right-12 top-5 "
                          alt=""
                        />
                      </div>

                      <img
                        src="/images/roll/right.webp"
                        className="w-14 md:w-[53px] blur-[2px] rotate-12 object-contain -ml-3 relative z-50"
                        alt=""
                      />
                    </div>
                  </>
                )}
              </div>

              <span className="mt-3 font-sofia md:text-xl 2xl:text-2xl font-extrabold text-sm text-white">
                {game.label}
              </span>
            </button>
          ))}
        </div>
 
      </div>
    </section>
  );
}
